#ifndef EF_REGISTRY_KEY_HPP
#define EF_REGISTRY_KEY_HPP

#include <atlbase.h>
#include "EFPlatform.hpp"

namespace EFramework
{
	/// Wraps reading and writing to the windows registry.
	class EF_EXPORT EFRegistryKey
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor, stores in HKEY_CURRENT_USER always.
		  */
		EFRegistryKey(const EFString& registryDirectoryName = "EFramework", const EFString& registryDirectory = "Software\\");

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Registry Writing Functions

		/** Writes an integer value to the registry.
		  */
		void WriteInteger(const EFString& valueName, ulong integer);
		/** Writes a string value to the registry.
		  */
		void WriteString(const EFString& valueName, const EFString& string);
		/** Writes an array of characters to the registry.
		  */
		void WriteString(const EFString& valueName, char* string);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Registry Reading Functions

		/** Reads an integer value from the registry.
		  */
		ulong ReadInteger(const EFString& valueName, ulong defaultValue);
		/** Reads a string value from the registry.
		  */
		char* ReadString(const EFString& valueName, char* defaultValue, ulong stringSize);
	protected:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Variables

		CRegKey mRegistryKey; ///< The ATL registry key wrapper class.
	};
} // Namespace EFramework

#endif // EF_REGISTRY_KEY_HPP